<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRun;

class OwnerReference extends \Google\Model
{
  /**
   * @var string
   */
  public $apiVersion;
  /**
   * @var bool
   */
  public $blockOwnerDeletion;
  /**
   * @var bool
   */
  public $controller;
  /**
   * @var string
   */
  public $kind;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $uid;

  /**
   * @param string
   */
  public function setApiVersion($apiVersion)
  {
    $this->apiVersion = $apiVersion;
  }
  /**
   * @return string
   */
  public function getApiVersion()
  {
    return $this->apiVersion;
  }
  /**
   * @param bool
   */
  public function setBlockOwnerDeletion($blockOwnerDeletion)
  {
    $this->blockOwnerDeletion = $blockOwnerDeletion;
  }
  /**
   * @return bool
   */
  public function getBlockOwnerDeletion()
  {
    return $this->blockOwnerDeletion;
  }
  /**
   * @param bool
   */
  public function setController($controller)
  {
    $this->controller = $controller;
  }
  /**
   * @return bool
   */
  public function getController()
  {
    return $this->controller;
  }
  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OwnerReference::class, 'Google_Service_CloudRun_OwnerReference');
